% -------------------------------------------------------------------------
% Course: Hydrology for Engineers
% exercise week 1: hydrologic balance
% -------------------------------------------------------------------------

% UNZIP THE FILES BEFORE EXECUTING THIS SCRIPT AND MAKE SURE THAT YOUR
% 'CURRENT FOLDER' IS WHERE THE DATA HAS BEEN UNZIPPED

clear variables %clear the workspace variables
close all %close alla figures
clc %clear the command window


% -------------------------------------------------------------------------
% #1 HYDROLOGIC DATA LOAD: the dataset is a comma-separated-value (csv)
% data file. All information on the data is reported in the file header.
% Open the file data2020.dat with a text editor to see how the datafile is
% organized. 
% For this first exercise, the code to load the data is alreay provided.
% -------------------------------------------------------------------------

% load the data into a data table using the function readtable
T = readtable('data2020.dat','NumHeaderLines',7);
        % the dataset is made of three columns that include:
        % 1-precipitation P, 2-Evapotranspiration ET, 3-leakage L
        % all fluxes are averages measured in mm/d over hourly time steps

% store info about the dataset
dt = 1/24;       %hourly time step, measured in days
N = size(T,1);   %number of elements, useful for any statistics

% if you want, you can extract the datatable into a matrix (note that with
% a Matrix you can use position indexing but not name indexing anymore)
M = T{1:end, 1:end}; %the table T has now been converted to matrix M

% or if you want, you can extract the table variables into separate vectors
P = T.P;  %precipitation [mm/d]
ET = T.ET; %evapotranspiration [mm/d]
L = T.L;  %leakage [mm/d]


% -------------------------------------------------------------------------
% #2 PLOT SOMETHING 
% check the matlab documentation for built-in functions like: 'plot' 
% -------------------------------------------------------------------------






% -------------------------------------------------------------------------
% #3 COMPUTE SOME STATISTICS
% check the matlab documentation for the built-in functions like: 
% sum, cumsum
% mean, std, hist, etc... 
% -------------------------------------------------------------------------

% ideas for statistics to compute and plot:
% ...total P, ET, L and plot with cumulative fluxes
% ...mean, standard deviation
% ...histograms







% -------------------------------------------------------------------------
% #4 COMPUTE THE WATER STORAGE EVOLUTION
% -------------------------------------------------------------------------









%--------------------------------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%%%%  END OF FILE  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
